﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="Dashboard.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Dashboard" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
    <title runat="server">Ei8ht POS - Dashboard</title>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:HiddenField ID="hdnEmails" runat="server" />
    <asp:HiddenField ID="hdnEmailContent" runat="server" />
    <!-- page header -->
    <div class="pageheader">


        <h2>
            <i class="fa fa-tachometer"></i> Ei8ht POS - Dashboard
        </h2>


        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">Dashboard</li>
            </ol>
        </div>


    </div>
    <!-- page header -->
    <!-- content main container -->
    <div class="main">

        <div class="row cards">

            <%--Cards Begin Here--%>

            <div class="card-container col-lg-3 col-sm-6 col-sm-12">
                <div class="card card-blue hover">
                    <div class="front">

                        <div class="media">
                            <span class="pull-left">
                                <i class="fa fa-shopping-cart media-object"></i>
                            </span>

                            <div class="media-body">
                                <small>New Orders</small>
                                <h2 class="media-heading animate-number" data-value="" data-animation-duration="1500" runat="server" id="stNewOrders">0</h2>
                            </div>
                        </div>

                        <div class="progress-list">
                            <div class="details">
                                <div class="title">New Orders for this month.</div>
                            </div>
                            <div class="clearfix"></div>
                        </div>

                    </div>
                    <div class="back">
                        <a href="Sales\Sales.aspx">
                            <i class="fa fa-bar-chart-o fa-4x"></i>
                            <span>Check Summary</span>
                        </a>
                    </div>
                </div>
            </div>


            <div class="card-container col-lg-3 col-sm-6 col-sm-12">
                <div class="card card-greensea hover">
                    <div class="front">

                        <div class="media">
                            <span class="pull-left">
                                <i class="fa fa-usd media-object"></i>
                            </span>

                            <div class="media-body">
                                <small>Sales</small>
                                <h2 class="media-heading animate-number" data-value="" data-animation-duration="1500" runat="server" id="stNewSales">0</h2>
                            </div>
                        </div>

                        <div class="progress-list">
                            <div class="details">
                                <div class="title">Sales Summary for this Month</div>
                            </div>
                            <div class="clearfix"></div>
                        </div>

                    </div>
                    <div class="back">
                        <a href="Sales\Sales.aspx">
                            <i class="fa fa-bar-chart-o fa-4x"></i>
                            <span>Check Summary</span>
                        </a>
                    </div>
                </div>
            </div>


            <div class="card-container col-lg-3 col-sm-6 col-xs-12">
                <div class="card card-slategray hover">
                    <div class="front">

                        <div class="media">
                            <span class="pull-left">
                                <i class="fa fa-eye media-object"></i>
                            </span>

                            <div class="media-body">
                                <small>Items Sold</small>
                                <h2 class="media-heading animate-number" data-value="" data-animation-duration="1500" runat="server" id="stItemsSold">0</h2>
                            </div>
                        </div>

                        <div class="progress-list">
                            <div class="details">
                                <div class="title">Number of Items sold this month</div>
                            </div>
                            <div class="clearfix"></div>
                        </div>

                    </div>
                    <div class="back">
                        <a href="Reports\BestSellersReport.aspx">
                            <i class="fa fa-bar-chart-o fa-4x"></i>
                            <span>Check Summary</span>
                        </a>
                    </div>
                </div>
            </div>


            <div class="card-container col-lg-3 col-sm-6 col-sm-12">
                <div class="card card-redbrown hover">
                    <div class="front">

                        <div class="media">
                            <span class="pull-left">
                                <i class="fa fa-users media-object"></i>
                            </span>

                            <div class="media-body">
                                <small>New Customers</small>
                                <h2 class="media-heading animate-number" data-value="" data-animation-duration="1500" runat="server" id="stUsers">0</h2>
                            </div>
                        </div>

                        <div class="progress-list">
                            <div class="details">
                                <div class="title">New Customers who joined us this month</div>
                            </div>
                            <div class="clearfix"></div>
                        </div>

                    </div>
                    <div class="back">
                        <a href="Customers\Customers.aspx">
                            <i class="fa fa-bar-chart-o fa-4x"></i>
                            <span>Check Summary</span>
                        </a>
                    </div>
                </div>
            </div>

            <%--Cards Ends Here--%>
        </div>

        <div class="row">

            <div class="col-lg-8 col-md-12">
                <section class="tile transparent">
                    <div class="tile-header color transparent-black textured rounded-top-corners">
                        <h1><strong>Sales Statistic</strong> - Last 6 Months</h1>
                    </div>
                    <div class="tile-widget color transparent-black textured">
                        <div id="statistics-chart" class="chart statistics" style="height: 250px;"></div>
                    </div>
                   
                </section>
                <%--<section class="tile color transparent-black">
                    <div class="tile-header">
                        <h1><strong>Projects</strong> Progress</h1>
                        <div class="search">
                            <input type="text" placeholder="Search...">
                        </div>
                    </div>
                    <div class="tile-body no-vpadding">
                        <div class="table-responsive">
                            <table class="table table-custom table-sortable nomargin">
                                <thead>
                                    <tr>
                                        <th class="sortable sort-numeric sort-asc">ID</th>
                                        <th class="sortable sort-alpha">Project</th>
                                        <th class="sortable">Priority</th>
                                        <th class="sortable sort-amount">Status</th>
                                        <th class="text-right">Chart</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1</td>
                                        <td>Graphic Layout for client</td>
                                        <td class="color-red priority">High priority</td>
                                        <td class="progress-cell">
                                            <div class="progress-info">
                                                <div class="percent"><span class="animate-number" data-value="50" data-animation-duration="1500">0</span>%</div>
                                            </div>
                                            <div class="progress progress-little">
                                                <div class="progress-bar progress-bar-transparent-white animate-progress-bar" data-percentage="50%"></div>
                                            </div>
                                        </td>
                                        <td class="text-right"><span id="projectbar1">87,85,42,90,70,55,82,68</span></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="tile-footer text-center">
                        <ul class="pagination pagination-sm nomargin pagination-custom">
                            <li class="disabled"><a href="#"><i class="fa fa-angle-double-left"></i></a></li>
                            <li class="active"><a href="#">1</a></li>
                            <li><a href="#">2</a></li>
                            <li><a href="#">3</a></li>
                            <li><a href="#">4</a></li>
                            <li><a href="#">5</a></li>
                            <li><a href="#"><i class="fa fa-angle-double-right"></i></a></li>
                        </ul>
                    </div>
                </section>--%>
            </div>

            <%--Top Customer  Pie Chart - Begins--%>
            <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12">

                <section class="tile color transparent-black">
                    <div class="tile-header">
                        <h1><strong>Top Customers</strong> By Order Value</h1>
                        <div class="controls">
                        </div>
                    </div>
                    <div class="tile-body">
                        <div id="top-customers" style="height: 230px;" class="morris-chart"></div>
                        <ul class="inline text-center chart-legend">
                            <asp:Repeater runat="server" ID="rpTopCustomers">
                                <ItemTemplate>
                                    <li><span class="badge badge-outline" style="border-color: #D9544F"></span><%# Eval("BillingName") %> <small>$<%# Eval("TotalSales") %></small>,</li>
                                </ItemTemplate>
                            </asp:Repeater>
                        </ul>
                    </div>
                     </section>
            </div>
            <%--Top Customer  Pie Chart - Ends--%>

            <%-- Email Customer - Begins--%>
            <div class="col-lg-8 col-md-12 col-sm-12 col-xs-12">
                <section class="tile transparent">
                    <div class="tile-header transparent">
                        <h1><strong>Quick Message</strong> To Customers</h1>
                    </div>
                   <div class="tile-widget color transparent-black rounded-top-corners">
                        <div class="form-group" style="height: 50px;">
                            <label for="message-to" class="col-sm-2 control-label font-slab">Customers</label>
                            <div class="col-sm-10">
                                <select data-placeholder="Select Customers..." multiple="" tabindex="3" class="chosen-select form-control chosen-transparent" id="message-to">
                                    <asp:Repeater runat="server" ID="rpEmailIDs">
                                        <ItemTemplate>
                                            <option value="<%# Eval("Email") %>"><%# Eval("Email") %></option>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </select>
                            </div>
                        </div>
                        <div class="form-group no-bottom-margin" style="height: 50px;">
                            <label for="subject" class="col-sm-2 control-label font-slab">Others</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control transparent" id="txtOthersEmail" runat="server" placeholder="Enter Email ID">
                            </div>
                        </div>
                        <div class="form-group no-bottom-margin" style="height: 50px;">
                            <label for="subject" class="col-sm-2 control-label font-slab">Subject</label>
                            <div class="col-sm-10">
                                <input type="text" class="form-control transparent" id="subject" placeholder="Type subject here..." runat="server">
                            </div>
                        </div>
                    </div>
                    <div class="tile-body nopadding">
                        <div id="quick-message-content"></div>
                    </div>
                    <div class="tile-footer rounded-bottom-corners text-right">
                        <a class="submit font-slab" href="#" onclick="sendEmail();" runat="server" onserverclick="SendEmail"> <strong>Send</strong> message <i class="fa fa-comment"></i></a>
                    </div>
                </section>
            </div>
            <%-- Email Customer - Ends--%>

            <div class="col-lg-4 col-md-12 col-sm-12 col-xs-12">

                <section class="tile color transparent-black">
                    <div class="tile-header">
                        <h1><strong>Top Products</strong> - Bestsellers</h1>
                        <div class="controls">
                        </div>
                    </div>
                    <div class="tile-body">
                        <div id="top-products" style="height: 230px;" class="morris-chart"></div>
                        <ul class="inline text-center chart-legend">
                            <asp:Repeater runat="server" ID="rpTopProducts">
                                <ItemTemplate>
                                    <li><span class="badge badge-outline" style="border-color: #D9544F"></span><%# Eval("ProductName") %> <small>$<%# Eval("TotalSales") %></small>,</li>
                                </ItemTemplate>
                            </asp:Repeater>
                        </ul>
                    </div>
                     </section>
            </div>
        </div>

        <br />
        <div class="row Footercenter">
            <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">

    <script>
        $(function () {
            // Initialize card flip
            $('.card.hover').hover(function () {
                $(this).addClass('flip');
            }, function () {
                $(this).removeClass('flip');
            });

            //Sales Statistics 12 Month Chart - Begin

            var d1 = [
                <% for (int i = 0; i < 7; i++)
                   {
                       Response.Write(string.Format("[{0},{1}]", i + 1, SalesAmount[i]));
                       if (i != 6) Response.Write(',');
                   } %>
            ];

            var d2 = [
                <% for (int i = 0; i < 7; i++)
                   {
                       Response.Write(string.Format("[{0},{1}]", i + 1, NoOfOrders[i]));
                       if (i != 6) Response.Write(',');
                   }
                %>
            ];

            var months = [<% for (int i = 0; i < 7; i++) { Response.Write(string.Format("\"{0}\"", Months[i])); if (i!=6) { Response.Write(","); } } %>];

            // flot chart generate
            var plot = $.plotAnimator($("#statistics-chart"),
            [
            {
                label: 'Sales',
                data: d1,
                lines: { lineWidth: 3 },
                shadowSize: 0,
                color: '#ffffff'
            },
            {
                label: "Orders",
                data: d2,
                animator: { steps: 99, duration: 500, start: 200, direction: "right" },
                lines: {
                    fill: .15,
                    lineWidth: 0
                },
                color: ['#ffffff']
            }, {
                label: 'Sales',
                data: d1,
                points: { show: true, fill: true, radius: 6, fillColor: "rgba(0,0,0,.5)", lineWidth: 2 },
                color: '#fff',
                shadowSize: 0
            },
            {
                label: "Orders",
                data: d2,
                points: { show: true, fill: true, radius: 6, fillColor: "rgba(255,255,255,.2)", lineWidth: 2 },
                color: '#fff',
                shadowSize: 0
            }
            ], {

                xaxis: {

                    tickLength: 0,
                    tickDecimals: 0,
                    min: 1,
                    ticks: [<% for (int i = 0; i < 7; i++) { Response.Write(string.Format("[{0},\"{1}\"]", i + 1, Months[i])); if (i != 6) { Response.Write(","); } } %>],
                    font: {
                        lineHeight: 24,
                        weight: "300",
                        color: "#ffffff",
                        size: 14
                    }
                },

                yaxis: {
                    ticks: 4,
                    tickDecimals: 0,
                    tickColor: "rgba(255,255,255,.3)",

                    font: {
                        lineHeight: 13,
                        weight: "300",
                        color: "#ffffff"
                    }
                },

                grid: {
                    borderWidth: {
                        top: 0,
                        right: 0,
                        bottom: 1,
                        left: 1
                    },
                    borderColor: 'rgba(255,255,255,.3)',
                    margin: 0,
                    minBorderMargin: 0,
                    labelMargin: 20,
                    hoverable: true,
                    clickable: true,
                    mouseActiveRadius: 6
                },

                legend: { show: false }
            });

            //Sales Statistics 12 Month Chart - End

            $(window).resize(function () {
                plot.resize();
                plot.setupGrid();
                plot.draw();
            });

            

            $('#mmenu').on(
            "opened.mm",
            function () {
                plot.resize();
                plot.setupGrid();
                plot.draw();
            }
            );

            $('#mmenu').on(
            "closed.mm",
            function () {
                plot.resize();
                plot.setupGrid();
                plot.draw();
            }
            );

            $("#statistics-chart").bind("plothover", function (event, pos, item) {
                if (item) {
                    var x = item.datapoint[0],
                    y = item.datapoint[1];

                    $("#tooltip").html('<h1 style="color: #418bca">' + months[x - 1] + '</h1>' + '<strong>' + y + '</strong>' + ' ' + item.series.label)
                    .css({ top: item.pageY - 30, left: item.pageX + 5 })
                    .fadeIn(200);
                } else {
                    $("#tooltip").hide();
                }
            });

            //tooltips options
            $("<div id='tooltip'></div>").css({
                position: "absolute",
                //display: "none",
                padding: "10px 20px",
                "background-color": "#ffffff",
                "z-index": "99999"
            }).appendTo("body");

            //generate actual pie charts
            $('.pie-chart').easyPieChart();


            // Morris donut chart
            Morris.Donut({
                element: 'top-customers',
                data: [
                    <% for (int i = 0; (topCustomer != null && i < topCustomer.Rows.Count && i < 5); i++)
                       { %>
                    <%= "{ label: '"%><%= topCustomer.Rows[i]["BillingName"].ToString()%><%="', value:"%><%=topCustomer.Rows[i]["TotalSales"].ToString()+ " }" %>
                    <% if (i != topCustomer.Rows.Count - 1)
                       {%>
                    <%=","%>
                    <% }
                       } %>
                ],
                colors: ['#00a3d8', '#2fbbe8', '#72cae7', '#d9544f', '#ffc100', '#1693A5']
            });

            $('#top-customers').find("path[stroke='#ffffff']").attr('stroke', 'rgba(0,0,0,0)');


            Morris.Donut({
                element: 'top-products',
                data: [
                    <% for (int i = 0; (bestSellerAllTime != null && i < bestSellerAllTime.Rows.Count && i < 5); i++)
                       { %>
                    <%= "{ label: '"%><%= bestSellerAllTime.Rows[i]["ProductName"].ToString()%><%="', value:"%><%=bestSellerAllTime.Rows[i]["TotalSales"].ToString()+ " }" %>
                    <% if (i != bestSellerAllTime.Rows.Count - 1)
                       {%>
                    <%=","%>
                    <% }
                       } %>
                ],
                colors: ['#ECD078', '#D95B43', '#C02942', '#542437', '#53777A', '#2fbbe8']
             });

            $('#top-products').find("path[stroke='#ffffff']").attr('stroke', 'rgba(0,0,0,0)');

          
            $('.tabdrop').tabdrop({ text: '<i class="fa fa-th-list"></i>' });

            //load wysiwyg editor
            $('#quick-message-content').summernote({
                toolbar: [
                //['style', ['style']], // no style button
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['fontsize', ['fontsize']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['height', ['height']],
                //['insert', ['picture', 'link']], // no insert buttons
                //['table', ['table']], // no table button
                //['help', ['help']] //no help button
                ],
                height: 143 //set editable area's height
            });

            //multiselect input
            $(".chosen-select").chosen({ disable_search_threshold: 10 });

        });

        function sendEmail() {
            $('#<%= hdnEmails.ClientID %>').val('');
            $('#<%= hdnEmailContent.ClientID %>').val($('.note-editable').text());
            $('.chosen-choices').find('span').each(function () {
                if($('#<%= hdnEmails.ClientID %>').val() =='')
                    $('#<%= hdnEmails.ClientID %>').val($(this).text());
                else
                    $('#<%= hdnEmails.ClientID %>').val($('#<%= hdnEmails.ClientID %>').val()+'|'+$(this).text());
            });

        }

    </script>

</asp:Content>
